unit Isam2dbf;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Isamtabl, Gauges, DB, DBTables, ExtCtrls,
  U_DbTool, Grids, DBGrids;

type
  DBASEExportProc = Procedure(var DATA; DBTable: TTable; ISTable: TIsamTable);

  TTransferDlg = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Table1: TTable;
    Gauge1: TGauge;
    IsamTable1: TIsamTable;
    StartBttn: TBitBtn;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure StartBttnClick(Sender: TObject);
  private
    { Private declarations }
  public
    StruGetProc : Structure_GetProc;
    FieldGetProc: DBASEExportProc;
    Data,Dup    : Pointer;
  end;

var
  TransferDlg: TTransferDlg;

Procedure Isam2DBase(aParent: TForm;
                     IsamTable: TIsamTable;
                     DBASETableName: String;
                     AliasName: String;
                     Stru_Get: Structure_GetProc;
                     FieldGet: DBASEExportProc);

Procedure Tabelle_Drucken(aParent: TForm;
                          IsamTable: TIsamTable;
                          DBASETableName: String;
                          AliasName: String;
                          Stru_Get: Structure_GetProc;
                          FieldGet: DBASEExportProc;
                          ReportName: String);

Procedure Datensatz_Drucken(aParent: TForm;
                            IsamTable: TIsamTable;
                            var DATA;
                            DBASETableName: String;
                            AliasName: String;
                            Stru_Get: Structure_GetProc;
                            FieldGet: DBASEExportProc;
                            ReportName: String);

implementation

Uses SysUtils, UToolDll, Filer{, CRPE_PRT};

{$R *.DFM}

Procedure Isam2DBase(aParent: TForm;
                     IsamTable: TIsamTable;
                     DBASETableName: String;
                     AliasName: String;
                     Stru_Get: Structure_GetProc;
                     FieldGet: DBASEExportProc);
var AktDir: String;
begin
  if Pos('.',DBaseTableName) > 0 then DBaseTableName:= Copy(DBaseTableName,1,Pos('.',DBaseTableName)-1);
  DBaseTableName:= DBaseTableName + '.DBF';
  AktDir:= ExtractFilePath(Application.ExeName);
  Check_Alias(AliasName,AktDir);
  TransferDlg:= TTransferDlg.Create(aParent);
  Try
    TransferDlg.IsamTable1:= IsamTable;
    TransferDlg.Table1.DataBaseName:= AliasName;
    TransferDlg.Table1.TableName:= DBaseTableName;
    TransferDlg.StruGetProc:= Stru_Get;
    TransferDlg.FieldGetProc:= FieldGet;
    TransferDlg.ShowModal;
  Finally
    TransferDlg.Free;
  end;
end;

Procedure Tabelle_Drucken(aParent: TForm;
                          IsamTable: TIsamTable;
                          DBASETableName: String;
                          AliasName: String;
                          Stru_Get: Structure_GetProc;
                          FieldGet: DBASEExportProc;
                          ReportName: String);
var AktDir: String;
    DbaseTbl: TTable;
    x,Max   : Longint;
    DATA,DUP: Pointer;
    Txt1    : String;
begin
  Max:= IsamTable.RecordCount;
  if Sprache = 1 then Txt1:= 'IsamTable is empty'
  else Txt1:= 'Isamtabelle ist leer';
  if Max = 0 then Errorwindow(Txt1,'')
  else begin
    if Pos('.',DBaseTableName) > 0 then DBaseTableName:= Copy(DBaseTableName,1,Pos('.',DBaseTableName)-1);
    DBaseTableName:= DBaseTableName + '.DBF';
    AktDir:= ExtractFilePath(Application.ExeName);
    Check_Alias(AliasName,AktDir);
    DbaseTbl:= TTable.Create(aParent);
    Try
      DbaseTbl.TableType:= ttDefault;
      DBaseTbl.DataBaseName:= AliasName;
      DBaseTbl.TableName:= DbaseTableName;
      if Erzeuge_Tabelle_Ohne_Index(aParent,
                                    DBaseTbl.DataBaseName,
                                    DBaseTbl.TableName,
                                    Stru_Get) then begin
        if Sprache = 1 then Txt1:= 'IsamTable is exported to DBASE'
        else Txt1:= 'Isamtabelle wird nach DBASE exportiert';
        WaitWindow(Txt1,'');
        DBaseTbl.Open;
        GetMem(DATA,IsamTable.RecSize);
        GetMem(DUP,IsamTable.RecSize);
        IsamTable.First(DATA^,DUP^);
        Max:= IsamTable.RecordCount;
        x:= 1;
        Repeat
          DBaseTbl.Insert;
          FieldGet(DATA^,DbaseTbl,IsamTable);
          DBaseTbl.Post;
          x:= x + 1;
          IsamTable.Next(DATA^,DUP^);
        Until (IsamOk = False) or (x > Max);
        FreeMem(DUP,IsamTable.RecSize);
        FreeMem(DATA,IsamTable.RecSize);
        DBaseTbl.Close;
        CloseWait;
        {CRPE_Drucken(ReportName,aParent);}
      end
      else Errorwindow('DBASE-Tabelle konnte nicht erzeugt werden','');
    Finally;
      DBaseTbl.Free;
    end;
  end;
end;

Procedure Datensatz_Drucken(aParent: TForm;
                            IsamTable: TIsamTable;
                            var DATA;
                            DBASETableName: String;
                            AliasName: String;
                            Stru_Get: Structure_GetProc;
                            FieldGet: DBASEExportProc;
                            ReportName: String);
var AktDir: String;
    DbaseTbl: TTable;
    Txt1    : String;
begin
  if Pos('.',DBaseTableName) > 0 then DBaseTableName:= Copy(DBaseTableName,1,Pos('.',DBaseTableName)-1);
  DBaseTableName:= DBaseTableName + '.DBF';
  AktDir:= ExtractFilePath(Application.ExeName);
  Check_Alias(AliasName,AktDir);
  DbaseTbl:= TTable.Create(aParent);
  Try
    DbaseTbl.TableType:= ttDefault;
    DBaseTbl.DataBaseName:= AliasName;
    DBaseTbl.TableName:= DbaseTableName;
    if Erzeuge_Tabelle_Ohne_Index(aParent,
                                  DBaseTbl.DataBaseName,
                                  DBaseTbl.TableName,
                                  Stru_Get) then begin
      if Sprache = 1 then Txt1:= 'IsamTable is exported to DBASE'
      else Txt1:= 'Isamtabelle wird nach DBASE exportiert';
      DBaseTbl.Open;
      DBaseTbl.Insert;
      FieldGet(DATA,DbaseTbl,IsamTable);
      DBaseTbl.Post;
      DBaseTbl.Close;
      {CRPE_Drucken(ReportName,aParent);}
    end
    else Errorwindow('DBASE-Tabelle konnte nicht erzeugt werden','');
  Finally;
    DBaseTbl.Free;
  end;
end;

procedure TTransferDlg.FormDestroy(Sender: TObject);
begin
  FreeMem(Data,IsamTable1.RecSize);
  FreeMem(Dup,IsamTable1.RecSize);
  if Table1.Active then Table1.Close;
end;

procedure TTransferDlg.FormCreate(Sender: TObject);
begin
  StruGetProc:= NIL;
  FieldGetProc:= NIL;
  if Sprache = 1 then CancelBtn.Caption:= 'End';
end;

procedure TTransferDlg.FormShow(Sender: TObject);
begin
  if not(Table_Exists(Table1)) then
    Erzeuge_Tabelle(Self,
                  Table1.DataBaseName,
                  Table1.TableName,
                  StruGetProc);
  Table1.Open;
  if Table1.Active then begin
    if Table1.RecordCount > 0 then begin
      if Sprache = 1 then begin
        if JaNein('DBASE-Tabelle already contains data','delete data ?') then begin
          Table1.Close;
          Table1.EmptyTable;
          Table1.Open;
        end;
      end
      else begin
        if JaNein('DBASE-Tabelle enthlt bereits Daten','Daten lschen ?') then begin
          Table1.Close;
          Table1.EmptyTable;
          Table1.Open;
        end;
      end;
    end;
  end
  else begin
    if Sprache = 1 then Errorwindow('Table could not be opened','')
    else Errorwindow('Tabelle konnte nicht erzeugt werden','');
  end;
  GetMem(Data,IsamTable1.RecSize);
  GetMem(Dup,IsamTable1.RecSize);
end;

procedure TTransferDlg.StartBttnClick(Sender: TObject);
var i,RCount: Longint;
    Altprogress,NeuProgress: Integer;
begin
  if Table1.Active then Table1.Close;
  Table1.DeleteTable;
  Erzeuge_Tabelle(Self,
                  Table1.DataBaseName,
                  Table1.TableName,
                  StruGetProc); 
  Table1.Open;
  if Table1.Active then begin
    if IsamTable1.Active then begin
      RCount:= IsamTAble1.RecordCount;
      IsamTable1.First(DATA^,DUP^);
      i:= 0;
      AltProgress:= 0;
      DBGrid1.Hide;
      Repeat
        IsamTable1.Get(DATA^,DUP^);
        if IsamOk then begin
          Table1.Append;
          FieldGetProc(DATA^,Table1,IsamTable1);
          Table1.Post;
          IsamTable1.Next(DATA^,DUP^);
        end;
        Inc(i);
        NeuProgress:= Round((i/RCount)*100);
        if AltProgress <> NeuProgress then begin
          AltProgress:= NeuProgress;
          Gauge1.Progress:= NeuProgress;
        end;
      Until (IsamOk = False) or (i = rCount);
      DbGrid1.Show;
    end
    else begin
      if Sprache = 1 then Errorwindow('Isamtable is not opened','')
      else Errorwindow('Isamtabelle ist nicht geffnet','');
    end;
  end
  else begin
    if Sprache = 1 then Errorwindow('DBASE-table is not opened','')
    else Errorwindow('DBASE-Tabelle ist nicht geffnet','');
  end;
end;

end.
